<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TypeCaisse extends Model 
{

    protected $table = 'types_caisses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'libelle', 'statut');
    protected $visible = array('slug', 'libelle', 'statut');

    public function montantTypeCaisse()
    {
        return $this->hasMany('App\Models\MontantTypeCaisse', 'id_typeCaisse');
    }

    public function creanceDetteFond()
    {
        return $this->hasMany('App\Models\CreanceDetteFond', 'id_typeCaisse');
    }

    public function mouvementEffectif()
    {
        return $this->hasMany('App\Models\MouvementEffectif', 'id_typeCaisse');
    }

    public function depense()
    {
        return $this->hasMany('App\Models\Depense', 'id_typeCaisse');
    }

}